﻿using VRM.Integration.Servicebus.Core;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VA.TMP.Integration.VIMT.Vista.Mappers;
using VA.TMP.Integration.VIMT.Vista.Links;


namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.CancelAppointment
{
    public class MapToProCancelAppointmentRequestStep:FilterBase<CancelAppointmentStateObject>
    {
        public override void Execute(CancelAppointmentStateObject state)
        {
            if (state.AppointmentType == AppointmentType.STORE_FORWARD)
                return;
            state.ProEcRequest = CancelAppointmentMapper.CancelAppointmentRequest(state, Side.Provider, Logger.Instance);

            var siteNum = state.ProEcRequest.VIMTVIASchedCancApReqqueryBeanInfo.VIMTVIASchedCancApReqproviderInfo.mcs_loginSiteCode;

            //DONE  Rusty (functional) - this needs to now include the SAML token as a parameter passed into this function - sourced from the plugin
            if (string.IsNullOrEmpty(state.ProUserDuz))
            {
                state.ProLoginRequest = new LoginMapper().GetLoginRequest(state.UserId, siteNum, state.OrganizationServiceProxy, state.SAMLToken);
            }
            else
                state.ProEcRequest.VIMTVIASchedCancApReqqueryBeanInfo.VIMTVIASchedCancApReqproviderInfo.mcs_userId = state.ProUserDuz;
        }
    }
}
